<?php
/**
 * @name		Extensions Manager CK
 * @package		com_extensionsmanagerck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

defined('_JEXEC') or die;
jimport('joomla.application.component.modellist');
jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');

class ExtensionsmanagerckModelExtensions extends \Joomla\CMS\MVC\Model\ListModel
{
	/*
	 * Load the extensions list
	 *
	 * Return Array - the list
	 */
	public function getItems($ids = array()) {
		$items = array();

		$xmlFile = JPATH_SITE . '/administrator/components/com_extensionsmanagerck/extensions.xml';
		$xml_parser = xml_parser_create();
		xml_parse_into_struct($xml_parser, file_get_contents($xmlFile), $fields);
		xml_parser_free($xml_parser);

		foreach ($fields as $field) {
			if ( (strtolower($field['tag']) != 'extension' && strtolower($field['tag']) != 'group')
				|| !isset($field['attributes'])
				) {
				continue;
			}

			$item = new stdClass();
			$this->initItem($item);

			foreach ($field['attributes'] as $key => $val)
			{
				if (strtolower($key) == 'type') {
					$item->type = $val;
					$item->types = explode(',', $val);
				} else {
					$item->{strtolower($key)} = $val;
				}
			}

			// check the extension version for the current website
			$majorVersion = substr(JVERSION, 0, 1);
			$joomlaversions = explode(',', $item->joomlaversion);
			if (! in_array($majorVersion, $joomlaversions) && strtolower($field['tag']) == 'extension') {
				$item->type = 'nocompat';
			} else if (strtolower($field['tag']) == 'group') {
				$item->type = 'group';
			} else {
				// $item->haspro = $item->ckpro == '1';
				// check the extension status
				$item->isInstalled = (int)$this->checkIfInstalled($item);
				if ($item->isInstalled) {
					// load the data from the installed xml
					$this->getDataFromXml($item);
					// check if pro or light installed
					if ($item->xmlData) {
						if (isset($item->xmlData->ckpro)) {
							$item->ispro = (string) $item->xmlData->ckpro;
						}
					}
					$item->installedVersion = $this->getInstalledVersion($item);
				} else {
					$item->installedVersion = '<span class="label">' . \Extensionsmanagerck\CKText::_('CK_NOT_INSTALLED') . '</span>';
				}
				// look for actions to process
				if (! $item->isInstalled ) {
					$item->action = 'install';
				} else if ($item->isInstalled && version_compare($item->installedVersion, $item->latestVersion) < 0) {
					$item->action = 'update';
				}
			}
			$items[] = $item;
		}

		return $items;
	}

	/*
	 * Create empty attributes for the item
	 */
	private function initItem(&$item) {
		$item->name = '';
		$item->type = '';
		$item->types = array();
		$item->folder = '';
		$item->element = '';
		$item->action = '';
		$item->downloadid = 0;
		$item->prodownloadid = 0;
		$item->isInstalled = 0;
		$item->isUpToDate = false;
		$item->installedVersion = '';
		$item->latestVersion = '';
		$item->updatexml = '';
		$item->ispaid = '0';
		$item->joomlaversion = '0';
		$item->xml = '';
		// $item->ckpro = ''; // from list of extensions : is there a pro version for this extension ?
		$item->haspro = '0'; // yes a pro version exists
		$item->ispro = '0'; // yes the pro version is installed
	}

	/* 
	 * Check if the extension is installed
	 *
	 * Return Boolean - True on success
	 */
	private function checkIfInstalled($item) {
		// if ($item->xml) {
			// $xmlFile = JPATH_SITE . '/' . $item->xml;
			// if (file_exists($xmlFile)) {
				// $item->xmlData = simplexml_load_file($xmlFile);
				// if ($item->ckpro === (string)$item->xmlData->ckpro) return true;
				// return false;
			// }
			// return false;
		// } else { // B/C
			$extensionFolder = $this->getExtensionFolder($item);
			if (! $extensionFolder) return false;

			return is_file(JPATH_SITE . $extensionFolder . $item->element . '.php')
				 || is_dir(JPATH_SITE . $extensionFolder);
		// }
	}

	private function getExtensionFolder($item) {
		if (isset($item->extensionFolder)) return $item->extensionFolder;

		if (stristr($item->type, 'com')) {
			$item->extensionFolder = ($item->folder ? '/' . $item->folder : '') . '/components/com_' . $item->element . '/' ;
		} else if (stristr($item->type, 'mod')) {
			$item->extensionFolder = '/modules/mod_' . $item->element . '/mod_' ;
		} else if (stristr($item->type, 'plg')) {
			$item->extensionFolder = '/plugins/' . $item->folder . '/' . $item->element . '/' ;
		} else if (stristr($item->type, 'all')) {
			$item->extensionFolder = '' ;
		}

		return $item->extensionFolder;
	}

	private function getInstalledVersion($item) {
		if (isset($item->version)) return $item->version;

		$item->version = false;
		if ($item->xml) {
			$xmlFile = JPATH_SITE . '/' . $item->xml;
		} else {
			$xmlFile = JPATH_SITE . $this->getExtensionFolder($item) . $item->element . '.xml';
		}

		if (! $xmlContent = simplexml_load_file($xmlFile)) {
			
		} else {
			$item->version = (string)$xmlContent->version;
		}

		return $item->version;
	}

	private function getDataFromXml(&$item) {
		if (isset($item->xmlData)) return $item->xmlData;

		if ($item->xml) {
			$xmlFile = JPATH_SITE . '/' . $item->xml;
		} else {
			$xmlFile = JPATH_SITE . $this->getExtensionFolder($item) . $item->element . '.xml';
		}
		if (! $xmlContent = simplexml_load_file($xmlFile)) {
			return false;
		} else {
			$item->xmlData = $xmlContent;
		}

		return $item->xmlData;
	}
}
