<?php
/**
 * @name		Extensions Manager CK
 * @package		com_extensionsmanagerck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

defined('_JEXEC') or die;

\Extensionsmanagerck\CKText::script('CK_LICENSE_EXPIRED');
\Extensionsmanagerck\CKText::script('CK_LICENSE_DAYS_LEFT');

\Joomla\CMS\HTML\HTMLHelper::_('jquery.framework');
\Joomla\CMS\HTML\HTMLHelper::_('bootstrap.framework');

$doc = \Extensionsmanagerck\CKFof::getDocument();
$config = \Joomla\CMS\Component\ComponentHelper::getParams('com_extensionsmanagerck');
$user  = \Joomla\CMS\Factory::getUser();

$doc->addStylesheet(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/ckbox.css');
$doc->addStylesheet(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/ckframework.css');
$doc->addStylesheet(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/extensionsmanagerck.css?ver=1.2.0');

$doc->addScript(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/ckbox.js');
$doc->addScript(\Extensionsmanagerck\CKUri::root(true) . '/administrator/components/com_extensionsmanagerck/assets/extensionsmanagerck.js?ver=1.2.0');
$doc->addScriptDeclaration('jQuery(document).ready(function (){
	// check the release notes
	ckloadAllData();
});');
$input = \Extensionsmanagerck\CKFof::getApplication()->input;
// save the license
$db = \Joomla\CMS\Factory::getDBO();
if ($input->get('task') == 'saveLicense') {
	\Joomla\CMS\Session\Session::checkToken() or jexit(\Extensionsmanagerck\CKText::_('JINVALID_TOKEN'));
	$license_code = $input->get('license_code', '', 'string');
	// store the domains
	
	$sql = 'UPDATE #__extensions SET custom_data = ' . $db->quote($license_code) . ' WHERE element = ' . $db->quote('com_extensionsmanagerck');
	$db->setQuery($sql) ;
	$updated = $db->execute();

	// $extra_query = $license_code ? 'license=' . $license_code : '';
	$extra_query = '';
	$sql = 'UPDATE #__update_sites SET extra_query = ' . $db->quote($extra_query) . ' WHERE location LIKE ' . $db->quote('%update.joomlack.fr%');
	$db->setQuery($sql) ;
	$updated = $db->execute();
}
// get the license code
$sql = 'SELECT custom_data FROM #__extensions'
. " WHERE element = " . $db->quote('com_extensionsmanagerck')
;
$db->setQuery($sql) ;
$license_code = $db->loadResult();
?>
<div class="ckwell">
<form method="post" name="adminForm" id="adminForm">
	<label for="license_code"><?php echo \Extensionsmanagerck\CKText::_('CK_LICENSE_CODE'); ?></label>
	<input type="text" id="license_code" name="license_code" value="<?php echo $license_code ?>"/>
	<button type="submit" class="btn btn-primary" style="margin-bottom: 9px;"><?php echo \Extensionsmanagerck\CKText::_('JAPPLY'); ?></button>
	<span id="license_code_valid" class="ckbadge ckbadge-success" style="display:none;"><?php echo \Extensionsmanagerck\CKText::_('CK_LICENSE_CODE_VALID'); ?></span>
	<span id="license_code_notvalid" class="ckbadge ckbadge-important" style="display:none;"><?php echo \Extensionsmanagerck\CKText::_('CK_LICENSE_CODE_NOTVALID'); ?></span>
	<p><a href="https://www.joomlack.fr/en/documentation/miscellaneous/202-license-code" target="_blank"><?php echo \Extensionsmanagerck\CKText::_('CK_LICENSE_CODE_DOCUMENTATION_LINK'); ?></a></p>
	<input type="hidden" name="task" value="saveLicense" />
	<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
</form>
</div>
<div class="ckwell">
<h1><?php echo \Extensionsmanagerck\CKText::_('CK_PACK_ALLINONE'); ?> <small><a href="https://www.joomlack.fr/en/pack-all-extensions" target="_blank"><?php echo \Extensionsmanagerck\CKText::_('CK_GETITHERE'); ?></a></small></h1>
<p><?php echo \Extensionsmanagerck\CKText::_('CK_PACK_ALLINONE_DESC'); ?></p>
</div>
<table class="table table-hover" id="extensionsList">
	<thead>
		<tr>
			<th class="left">
				<?php echo \Extensionsmanagerck\CKText::_('CK_NAME'); ?>
			</th>

			<th class="">
				<?php echo \Extensionsmanagerck\CKText::_('CK_LICENSE'); ?>
			</th>
			<th  class="center">
				<?php echo \Extensionsmanagerck\CKText::_('CK_INSTALLED_VERSION'); ?>
			</th>
			
			<th  class="center">
				<?php echo \Extensionsmanagerck\CKText::_('CK_LATEST_VERSION'); ?>
			</th>
			<th  class="center">
				
			</th>

			<th class="">

			</th>
		</tr>
	</thead>
	<tbody>
		<?php
	// var_dump($this->items);
		foreach ($this->items as $i => $item) :

			// $link = 'index.php?option=com_templateck&view=template&task=template.edit&id=' . $item->id;
			if ($item->type == 'group') {
				?>
				<tr class="ckheading" data-element="<?php echo $item->element ?>">
					<td colspan="5">
						<?php echo $item->name; ?>
					</td>
					<td class="ckinfourl">
						<?php // filled with JS */ ?>
						<a class="btn btn-small" href="" target="_blank" style="display:none;"><?php echo \Extensionsmanagerck\CKText::_('CK_GO_WEBSITE') ?></a>
					</td>
				</tr>
				<?php
			} else if ($item->type == 'nocompat') {
				?>
				<tr class="row<?php echo $i % 2; ?> ckextension ckcompat0">
					<td>
					<?php echo " - " . $item->name; ?> - <?php echo \Extensionsmanagerck\CKText::_('CK_NOT_COMPATIBLE'); ?>
					</td>
				</tr>
				<?php
			} else {
				?>
				<tr class="row<?php echo $i % 2; ?> ckextension" 
					data-installed="<?php echo $item->isInstalled ?>" 
					data-element="<?php echo $item->element ?>" 
					data-type="<?php echo $item->types[0] ?>" 
					data-folder="<?php echo $item->folder ?>" 
					data-updatexml="<?php echo $item->updatexml ?>"
					data-downloadid="<?php echo ($item->ispro && $item->prodownloadid ? $item->prodownloadid : $item->downloadid) ?>"
					data-downloadid-pro="<?php echo (isset($item->prodownloadid) && $item->prodownloadid ? $item->prodownloadid : '') ?>"
					data-haspro="<?php echo $item->haspro ?>"
					data-ispro="<?php echo ($item->haspro && $item->ispro ? '1' : '0') ?>"
					data-ispaid="<?php echo ($item->haspro ? $item->ispro : $item->ispaid) ?>"
					data-update="0"
					>
					
					<td>
						<?php echo " - " . $item->name; ?>
						<?php
							if ($item->haspro) {
								if ($item->ispro === '1') {
									?>
									<span class="ckbadge ckbadge-success"><?php echo \Extensionsmanagerck\CKText::_('CK_PRO_VERSION'); ?></span>
									<?php
								} else if ($item->isInstalled) {
									?>
									<span class="ckbadge ckbadge-warning"><?php echo \Extensionsmanagerck\CKText::_('CK_LIGHT_VERSION'); ?></span>
									<br/>
									<span class="ckinfourl">
									<a href="http://www.joomlack.fr/index.php?option=com_dms&view=document&id=<?php echo $item->prodownloadid ?>" target="_blank"><?php echo \Extensionsmanagerck\CKText::_('CK_GET_PRO_VERSION'); ?></a>
									</span>
									<?php
								}
							}
						?>
					</td>
					<td class="cklicense">
						
					</td>
					<td class="center ckinstalledversion">
						<?php if ($item->type !== 'all') { ?>
							<span class="ckbadge ckversion"><?php echo $item->installedVersion; ?></span>
						<?php } ?>
					</td>
					<td class="center cklatestversion">
						<?php if ($item->type !== 'all') { ?>
							<span class="ckbadge ckbadge-inverse"><span>Loading ...</span></span>
						<?php } ?>
					</td>
					<td class="center">
						<?php if ($item->type !== 'all') { ?>
							<?php if ($user->authorise('core.admin', 'com_installer') && $user->authorise('core.manage', 'com_installer')) { ?>
								<?php
								$install = 'display:none;';
								$purchase = 'display:none;';
								$update = 'display:none;';
								?>
								<?php 
								if (! $item->isInstalled && $item->downloadid) {
									if (! $item->ispaid) { 
										$install = 'display:block;';
									} else { 
										$purchase = 'display:block;';
									} 
								} else {
									// $update = 'display:block;';
								}
								?>
								<span class="btn btn-success btn-small ckinstallbtn" style="<?php echo $install ?>" onclick="ckInstallExt(this)"><?php echo \Extensionsmanagerck\CKText::_('CK_INSTALL') ?> <?php echo ($item->prodownloadid ? 'LIGHT' : '') ?></span>
								<?php if ($item->prodownloadid ) { ?><span class="btn btn-success btn-small ckinstallbtn ckinstallbtnpro" style="<?php echo $install ?>" onclick="ckInstallExt(this, true)"><?php echo \Extensionsmanagerck\CKText::_('CK_INSTALL') ?> PRO</span><?php } ?>
								<a class="btn btn-info btn-small ckpurchasebtn" style="<?php echo $purchase ?>" href="https://www.joomlack.fr/index.php?option=com_dms&task=add_to_cart&id==<?php echo $item->prodownloadid ?>" target="_blank"><?php echo \Extensionsmanagerck\CKText::_('CK_PURCHASE') ?></a>
								<span class="btn btn-success btn-small ckupdatebtn" style="<?php echo $update ?>" onclick="ckInstallExt(this)"><?php echo \Extensionsmanagerck\CKText::_('CK_UPDATE') ?></span>
							<?php } ?>
						<?php } ?>
					</td>
					
					<td class="center ckreleasenotes">
						<span style="display:none;" class="btn btn-small ckreleasenotesbtn" style="" onclick="ckShowReleaseNotes(this)"><?php echo \Extensionsmanagerck\CKText::_('CK_SEE_RELEASE_NOTES') ?></span>
						<div style="display:none;" class="ckreleasenotespopup" id="ckreleasenotespopup<?php echo $i ?>"></div>
					</td>
					
				</tr>
			<?php } ?>
		<?php endforeach; ?>
	</tbody>
</table>
<div class="ckwell" style="text-align: center;">
	<a href="https://www.template-creator.com" target="_blank" rel="noopener noreferrer" style="width: 97%;"><img src="https://www.joomlack.fr/images/template_creator_ck_large_449.png" alt="template creator ck" style="margin: 0px auto 10px; display: block;" width="449" height="100">
	<span style="font-size: 14pt;">Template Creator CK<br></span></a>
	<p><?php echo \Extensionsmanagerck\CKText::_('CK_TEMPLATECREATORCK_DESC'); ?></p>
</div>
<div id="ckmessagespopup"></div>
