<?php
/**
 * @name		Mobile Menu CK
 * @copyright	Copyright (C) 2017. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

// No direct access
defined('_JEXEC') or die;

use Mobilemenuck\CKController;

class MobilemenuckControllerImport extends CKController {

	public function maximenuck($key = null, $urlVar = null) {
		MobilemenuckHelper::checkToken();
		$app = \Mobilemenuck\CKFof::getApplication();

		// Create a new query object.
		$db = \Mobilemenuck\CKFof::getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('params');
		$query->from('`#__extensions`');
		$query->where('`element` = \'maximenuckmobile\'');

		// Reset the query using our newly populated query object.
		$db->setQuery($query);
		// Load the results as a list of stdClass objects (see later for more options on retrieving data).
		$params = $db->loadResult();

		$params = new \Mobilemenuck\CKRegistry($params);

// maximenumobile_customcss
// maximenumobile_menubarbuttoncontent
// maximenumobile_topbarbuttoncontent

		// Initialise variables.
		JLoader::register('MobilemenuckTableStyles', JPATH_COMPONENT_ADMINISTRATOR . '/tables/styles.php');
		$table = \Joomla\CMS\Table\Table::getInstance('Styles', 'MobilemenuckTable');

		$data = array();
		$data['params'] = str_replace('|qq|', '"', $params->get('maximenumobile_styles'));
		$data['name'] = 'Imported : Maximenu CK Mobile';

		if ($table->save($data) === true) {
			$message = \Mobilemenuck\CKText::_('CK_IMPORT_SUCCESS');
			$type = 'message';
		} else {
			$message = \Mobilemenuck\CKText::_('CK_IMPORT_ERROR');
			$type = 'error';
		}

		$app->redirect(MOBILEMENUCK_ADMIN_URI . '&view=styles', $message, $type);

	}
}