<?php
/**
 * @name		Mobile Menu CK
 * @package		com_mobilemenuck
 * @copyright	Copyright (C) 2017. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

defined('_JEXEC') or die;

use \Mobilemenuck\CKText;

?>
<link rel="stylesheet" href="<?php echo MOBILEMENUCK_MEDIA_URI ?>/assets/ckframework.css" type="text/css" />
<link rel="stylesheet" href="<?php echo MOBILEMENUCK_MEDIA_URI ?>/assets/ckbox.css" type="text/css" />
<link rel="stylesheet" href="<?php echo MOBILEMENUCK_MEDIA_URI ?>/assets/colpick.css" type="text/css" />
<link rel="stylesheet" href="<?php echo MOBILEMENUCK_MEDIA_URI ?>/assets/admin.css" type="text/css" />

<div style="margin:20px 20px 20px 0">
	<?php //MobilemenuckHelper::displayMessages(); ?>
	<form action="<?php echo (MOBILEMENUCK_ADMIN_URI  . '&view=menu&layout=edit&id=' . (int) $this->item->id); ?>" enctype="multipart/form-data" method="post" name="adminForm" id="adminForm" class="form-validate ckinterface">
		<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
		<input type="hidden" name="task" value="menu.save" />
		<input type="hidden" name="type" value="custom" />
		<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
		<div>
			<label class="required" for="name">
				<?php echo CKText::_('CK_TITLE'); ?>
				<span class="star">&nbsp;*</span>
			</label>
			<input type="text" aria-required="true" required="required" size="40" class="required" value="<?php echo (isset($this->item->name) ? $this->item->name : '') ?>" id="name" name="name">
		</div>
		<hr />
		<div>
			<label for="state">
				<?php echo CKText::_('Enabled'); ?>
			</label>
			<?php echo $this->fields->render('select', 'state', $this->item->state, 
				array(
				'0' => CKText::_('JNO')
				,'1' => CKText::_('JYES')
				)); 
			?>
		</div>
		<h3><?php echo CKText::_('Menu location'); ?></h3>
		<div>
			<label for="menuselector">
				<?php echo CKText::_('CSS selector'); ?>
				<span class="star">&nbsp;*</span>
			</label>
			<input type="text" value="<?php echo $this->item->params->get('selector') ?>" id="selector" name="params[selector]" placeholder="">
			<span class="description"><?php echo CKText::_('You must give a CSS selector to find where your menu is located in the page. Example : #nav'); ?></span>
		</div>
		<h3><?php echo CKText::_('Options'); ?></h3>
		<div>
			<label for="menuid">
				<?php echo CKText::_('Menu ID'); ?>
			</label>
			<input type="text" value="<?php echo $this->item->params->get('menuid') ?>" id="menuid" name="params[menuid]" placeholder="">
			<span class="description"><?php echo CKText::_('Leave this field blank to let the system generate automatically an ID for your menu'); ?></span>
		</div>
		<div>
			<label for="menuselector">
				<?php echo CKText::_('Menu selector'); ?>
			</label>
			<input type="text" value="<?php echo $this->item->params->get('menuselector') ?>" id="menuselector" name="params[menuselector]" placeholder="ul">
		</div>
		<div>
			<label for="childselector">
				<?php echo CKText::_('Child items selector'); ?>
			</label>
			<input type="text" value="<?php echo $this->item->params->get('childselector') ?>" id="childselector" name="params[childselector]" placeholder="li">
		</div>
		<div>
			<label for="resolution">
				<?php echo CKText::_('Resolution for activation'); ?>
			</label>
			<input type="text" value="<?php echo $this->item->params->get('resolution', '') ?>" id="resolution" name="params[resolution]" placeholder="800">
		</div>
		<div>
			<label for="style">
				<?php echo CKText::_('Style'); ?>
			</label>
			<?php echo $this->fields->render('select', 'style', $this->item->style, 
				MobilemenuckHelper::getStylesList()); 
			?>
		</div>
		<div>
			<label for="container">
				<?php echo CKText::_('Menu place'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[container]', $this->item->params->get('container'), 
				array(
				'menucontainer' => CKText::_('Menu container')
				,'body' => CKText::_('Body')
				,'topfixed' => CKText::_('Top fixed')
				,'custom' => CKText::_('Custom')
				)); 
			?>
		</div>
		<div>
			<label for="custom_position">
				<?php echo CKText::_('Custom place'); ?>
			</label>
			<input type="text" value="<?php echo $this->item->params->get('custom_position') ?>" id="custom_position" name="params[custom_position]" placeholder="#css_selector">
		</div>
		
		<div>
			<label for="displayeffect">
				<?php echo CKText::_('Display effect'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[displayeffect]', $this->item->params->get('displayeffect'), 
				array(
				'normal' => CKText::_('Normal')
				,'slideleft' => CKText::_('Slide left')
				,'slideright' => CKText::_('Slide right')
				,'slideleftover' => CKText::_('Slide left over')
				,'sliderightover' => CKText::_('Slide right over')
				,'topfixed' => CKText::_('Top fixed')
				,'open' => CKText::_('Open')
				)); 
			?>
		</div>
		<fieldset>
			<legend>Slide options</legend>
				<div>
				<label for="menuwidth">
					<?php echo CKText::_('Menu width'); ?>
				</label>
				<input type="text" value="<?php echo $this->item->params->get('menuwidth') ?>" id="menuwidth" name="params[menuwidth]" placeholder="300">
			</div>
		</fieldset>
		<div>
			<label for="displaytype">
				<?php echo CKText::_('Display type'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[displaytype]', $this->item->params->get('displaytype'), 
				array(
				'flat' => CKText::_('Flat')
				,'accordion' => CKText::_('Accordion')
				,'fade' => CKText::_('Fade')
				,'push' => CKText::_('Push')
				)); 
			?>
		</div>
		<fieldset>
			<legend>Accordion options</legend>
			<div>
				<label for="openedonactiveitem">
					<?php echo CKText::_('PLG_MOBILEMENUCK_OPENED_ON_ACTIVE_ITEM_LABEL'); ?>
				</label>
				<?php echo $this->fields->render('select', 'params[openedonactiveitem]', $this->item->params->get('openedonactiveitem'), 
					array(
					'0' => CKText::_('JNO')
					,'1' => CKText::_('JYES')
					)); 
				?>
			</div>
			<div>
				<label for="accordion_use_effects">
					<?php echo CKText::_('PLG_MOBILEMENUCK_ACCORDION_EFFECT_LABEL'); ?>
				</label>
				<?php echo $this->fields->render('select', 'params[accordion_use_effects]', $this->item->params->get('accordion_use_effects'), 
					array(
					'0' => CKText::_('JNO')
					,'1' => CKText::_('JYES')
					)); 
				?>
			</div>
			<div>
				<label for="accordion_toggle">
					<?php echo CKText::_('PLG_MOBILEMENUCK_ACCORDION_TOGGLE_LABEL'); ?>
				</label>
				<?php echo $this->fields->render('select', 'params[accordion_toggle]', $this->item->params->get('accordion_toggle'), 
					array(
					'0' => CKText::_('JNO')
					,'1' => CKText::_('JYES')
					)); 
				?>
			</div>
		</fieldset>
		
		<div>
			<label for="showmobilemenutext">
				<?php echo CKText::_('CK_SHOWMOBILEMENUTEXT_LABEL'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[showmobilemenutext]', $this->item->params->get('showmobilemenutext', '1'), 
				array(
				'default' => CKText::_('JYES')
				,'none' => CKText::_('JNO')
				)); 
			?>
		</div>
		<div>
			<label for="beforetext">
				<?php echo CKText::_('Before text'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('beforetext', '')) ?>" id="beforetext" name="params[beforetext]" placeholder="">
		</div>
		<div>
			<label for="aftertext">
				<?php echo CKText::_('After text'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('aftertext', '')) ?>" id="aftertext" name="params[aftertext]" placeholder="">
		</div>
		<div>
			<label for="lock_button">
				<?php echo CKText::_('PLG_MOBILEMENUCK_LOCK_BUTTON_LABEL'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[lock_button]', $this->item->params->get('lock_button', '0'), 
				array(
				'1' => CKText::_('JYES')
				,'0' => CKText::_('JNO')
				)); 
			?>
		</div>
		<div>
			<label for="lock_forced">
				<?php echo CKText::_('PLG_MOBILEMENUCK_LOCK_FORCED_LABEL'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[lock_forced]', $this->item->params->get('lock_forced', '0'), 
				array(
				'1' => CKText::_('JYES')
				,'0' => CKText::_('JNO')
				)); 
			?>
		</div>
		<div>
			<label for="counter">
				<?php echo CKText::_('PLG_MOBILEMENUCK_COUNTER_LABEL'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[counter]', $this->item->params->get('counter', '0'), 
				array(
				'1' => CKText::_('JYES')
				,'0' => CKText::_('JNO')
				)); 
			?>
		</div>
		<div>
			<label for="search">
				<?php echo CKText::_('PLG_MOBILEMENUCK_SEARCH_LABEL'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[search]', $this->item->params->get('search', '0'), 
				array(
				'1' => CKText::_('JYES')
				,'0' => CKText::_('JNO')
				)); 
			?>
		</div>
		<div>
			<label for="overlay">
				<?php echo CKText::_('PLG_MOBILEMENUCK_OVERLAY_LABEL'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[overlay]', $this->item->params->get('overlay', '0'), 
				array(
				'1' => CKText::_('JYES')
				,'0' => CKText::_('JNO')
				)); 
			?>
		</div>

		<h3><?php echo CKText::_('Logo options'); ?></h3>
		<div>
			<label for="showlogo">
				<?php echo CKText::_('PLG_MOBILEMENUCK_SHOWLOGO_LABEL'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[showlogo]', $this->item->params->get('showlogo', '0'), 
				array(
				'1' => CKText::_('JYES')
				,'0' => CKText::_('JNO')
				)); 
			?>
		</div>
		<div>
			<label for="logo_where">
				<?php echo CKText::_('PLG_MOBILEMENUCK_LOGO_WHERE_LABEL'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[logo_where][]', $this->item->params->get('logo_where', '1'), 
				array(
				'1' => CKText::_('PLG_MOBILEMENUCK_SHOWLOGO_MOBILE')
				,'2' => CKText::_('PLG_MOBILEMENUCK_SHOWLOGO_MENUBAR')
				,'3' => CKText::_('PLG_MOBILEMENUCK_SHOWLOGO_TOPBAR')
				),$classname = '',  $isfiles = false, $attribs = ' multiple="true"'); 
			?>
		</div>
		<div>
			<input type="hidden" value="custom" id="logo_source" name="params[logo_source]" placeholder="">
		</div>
		<div>
			<label for="logoimage">
				<?php echo CKText::_('PLG_MOBILEMENUCK_LOGOIMAGE_LABEL'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('logoimage', '')) ?>" id="logoimage" name="params[logoimage]" placeholder="e.g. : images/banners/white.png">
		</div>
		<div>
			<label for="logolink">
				<?php echo CKText::_('PLG_MOBILEMENUCK_LOGOLINK_LABEL'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('logolink', '')) ?>" id="logolink" name="params[logolink]" placeholder="">
		</div>
		<div>
			<label for="logoalt">
				<?php echo CKText::_('PLG_MOBILEMENUCK_LOGOALT_LABEL'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('logoalt', '')) ?>" id="logoalt" name="params[logoalt]" placeholder="">
		</div>
		<div>
			<label for="logoposition">
				<?php echo CKText::_('PLG_MOBILEMENUCK_LOGOPOSITION_LABEL'); ?>
			</label>
			<?php echo $this->fields->render('select', 'params[logoposition]', $this->item->params->get('logoposition', 'left'), 
				array(
				'left' => CKText::_('PLG_MOBILEMENUCK_LEFT')
				,'center' => CKText::_('PLG_MOBILEMENUCK_CENTER')
				,'right' => CKText::_('PLG_MOBILEMENUCK_RIGHT')
				)); 
			?>
		</div>
		<div>
			<label for="logowidth">
				<?php echo CKText::_('PLG_MOBILEMENUCK_LOGOWIDTH_LABEL'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('logowidth', '')) ?>" id="logowidth" name="params[logowidth]" placeholder="e.g. : 300">
		</div>
		<div>
			<label for="logoheight">
				<?php echo CKText::_('PLG_MOBILEMENUCK_LOGOHEIGHT_LABEL'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('logoheight', '')) ?>" id="logowidth" name="params[logoheight]" placeholder="e.g. : 50">
		</div>
		<div>
			<label for="logomargintop">
				<?php echo CKText::_('PLG_MOBILEMENUCK_MARGINTOP_LABEL'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('logomargintop', '')) ?>" id="logowidth" name="params[logomargintop]" placeholder="e.g. : 5">
		</div>
		<div>
			<label for="logomarginright">
				<?php echo CKText::_('PLG_MOBILEMENUCK_MARGINRIGHT_LABEL'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('logomarginright', '')) ?>" id="logowidth" name="params[logomarginright]" placeholder="e.g. : 5">
		</div>
		<div>
			<label for="logomarginbottom">
				<?php echo CKText::_('PLG_MOBILEMENUCK_MARGINBOTTOM_LABEL'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('logomarginbottom', '')) ?>" id="logowidth" name="params[logomarginbottom]" placeholder="e.g. : 5">
		</div>
		<div>
			<label for="logomarginleft">
				<?php echo CKText::_('PLG_MOBILEMENUCK_MARGINLEFT_LABEL'); ?>
			</label>
			<input type="text" value="<?php echo htmlspecialchars($this->item->params->get('logomarginleft', '')) ?>" id="logowidth" name="params[logomarginleft]" placeholder="e.g. : 5">
		</div>

	</form>
</div>

<script>
function ckSaveMenu() {
	var nameField = document.getElementById('name');
	if (document.getElementById('name').value == '') {
		nameField.className += ' invalid';
		alert('Please give a name');
		return;
	}

	jQuery('#adminForm').submit();
}
</script>
<style>
.ckinterface label {
	width: 150px;
	display: inline-block;
}

.ckinterface {
	padding: 10px;
}

fieldset {
	border: 1px solid #ccc;
	padding: 10px;
	margin: 10px 0;
}

legend {
	float: none;
	width: auto;
	padding: 0 10px;
	margin: 0;
	font-weight: 600;
	font-size: 0.9em;
}
</style>