<?php
/**
 * @name		Mobile Menu CK
 * @copyright	Copyright (C) 2017. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

// No direct access
defined('_JEXEC') or die;

use Mobilemenuck\CKController;

class MobilemenuckControllerStyle extends CKController {

	public $redirect;

	public function __construct() {
		$this->redirect = MOBILEMENUCK_ADMIN_GENERAL_URL . '&view=styles';
		parent::__construct();
	}

	public function save() {
		// security check
		CKFof::checkAjaxToken(true);

		// get data
		$id = $this->input->get('id', 0, 'int');
		$name = $this->input->get('name', '', 'string');
//		$fields = $this->input->get('fields', '', 'raw');
		$customcss = $this->input->get('customcss', '', 'raw');
		$params = $this->input->get('fields', '', 'raw');
		$layoutcss = $this->input->get('layoutcss', '', 'raw');

		// load the item
		$model = $this->getModel();
		$row = $model->getItem($id);
		$row->id = (int)$row->id;
		$row->state = (int)$row->state;

		// set data
//		$row->params = Style::updateInterface($fields);
		$row->name = $name;
		$row->checkedout = '';
		$row->params = $params;
		$row->customcss = $customcss;
		$row->layoutcss = $layoutcss;

		if (! $id = $model->save($row)) {
			echo "{'result': '0', 'id': '" . $row->id . "', 'message': 'Error : Can not save the Styles !'}";
			exit;
		}

		echo '{"result": "1", "id": "' . $id . '", "moduleid": "0", "message": "Styles saved successfully"}';
		exit;
	}
}