DROP TABLE IF EXISTS `bf_core_hashes`;
DROP TABLE IF EXISTS `bf_folders_to_scan`;
DROP TABLE IF EXISTS `bf_files`;
DROP TABLE IF EXISTS `bf_folders`;
DROP TABLE IF EXISTS `bf_scan_state`;

CREATE TABLE `bf_core_hashes`
(
    `id`           int                                                         NOT NULL AUTO_INCREMENT,
    `filewithpath` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
    `hash`         varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `filewithpath` (`filewithpath`(191)),
    KEY `hash` (`hash`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_bin;

CREATE TABLE `bf_files`
(
    `id`             int NOT NULL AUTO_INCREMENT,
    `filewithpath`   blob,
    `fileperms`      varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
    `filemtime`      varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
    `toggler`        int                                                    DEFAULT NULL,
    `currenthash`    varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin  DEFAULT NULL,
    `lasthash`       varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
    `iscorefile`     int                                                    DEFAULT NULL,
    `hashfailed`     int                                                    DEFAULT NULL,
    `hashchanged`    int                                                    DEFAULT NULL,
    `hacked`         int                                                    DEFAULT NULL,
    `skipped`        int                                                    DEFAULT NULL,
    `suspectcontent` int                                                    DEFAULT NULL,
    `falsepositive`  int                                                    DEFAULT NULL,
    `mailer`         int                                                    DEFAULT NULL,
    `uploader`       int                                                    DEFAULT NULL,
    `encrypted`      int                                                    DEFAULT NULL,
    `queued`         int                                                    DEFAULT NULL,
    `size`           int                                                    DEFAULT NULL,
    `needscompat`    int                                                    DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `currenthash` (`currenthash`),
    KEY `iscorefile` (`iscorefile`),
    KEY `filewithpath` (`filewithpath`(191)),
    KEY `size` (`size`),
    KEY `hashfailed` (`hashfailed`),
    KEY `size_2` (`size`, `hashfailed`, `filewithpath`(191), `iscorefile`, `currenthash`),
    KEY `encrypted` (`encrypted`),
    KEY `queued` (`queued`),
    KEY `mailer` (`mailer`),
    KEY `uploader` (`uploader`),
    KEY `hacked` (`hacked`),
    KEY `skipped` (`skipped`),
    KEY `needscompat` (`needscompat`),
    KEY `suspectcontent` (`suspectcontent`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_bin;

CREATE TABLE `bf_folders`
(
    `id`             int NOT NULL AUTO_INCREMENT,
    `folderwithpath` blob,
    `folderinfo`     varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
    `foldermtime`    varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
    `filesinfolder`  int                                                    DEFAULT NULL,
    `queued`         int                                                    DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `folderwithpath` (`folderwithpath`(191)),
    KEY `folderinfo` (`folderinfo`),
    KEY `foldermtime` (`foldermtime`),
    KEY `queued` (`queued`),
    KEY `filesinfolder` (`filesinfolder`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  ROW_FORMAT = DYNAMIC
  COLLATE = utf8mb4_bin;

CREATE TABLE `bf_folders_to_scan`
(
    `id`             int NOT NULL AUTO_INCREMENT,
    `folderwithpath` blob,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_bin;
