<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

use Joomla\CMS\Authentication\Authentication;
use Joomla\CMS\Authentication\AuthenticationResponse;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\User\UserFactoryInterface;
use Joomla\Registry\Registry;

try {
    require 'bfEncrypt.php';
    /*
     * If we have got here then we have already passed through decrypting
     * the encrypted header, and so we are sure we are now secure and no one
     * else cannot run the code below.
     */

    if (! defined('BF_JOOMLA_INIT_DONE')) {
        require_once 'bfInitJoomla.php';
    }

    $container = Factory::getContainer();
    $app       = Factory::getApplication();
    $session   = $app->getSession();

    /** @var stdClass $dataObj The incoming decrypted request */
    $user = $container->get(UserFactoryInterface::class)->loadUserById((int) $dataObj->id);

    $subfolderIfAny = null;

    if (is_array($_SERVER) && array_key_exists('REQUEST_URI', $_SERVER)) {
        $url = preg_replace('/\?.*/', '', (string) $_SERVER['REQUEST_URI']);

        $subfolderIfAny = str_replace('/plugins/system/bfnetwork/bfnetwork/bfAutologin.php', '', $url);
    }

    // Load the required user from the database - Bail out if that user doesn't exist
    if (! $user->id) {
        throw new Exception('User not found');
    }

    // Set user into the app early so plugins see it if they fire onUserLogin
    // Bypass MFA/2FA
    $session->set('com_users.mfa_checked', 1);
    $session->set('com_users.mandatory_mfa_setup', 0);
    $session->set('registry', new Registry());
    $session->set('user', $user);
    Factory::getApplication()->loadIdentity($user);

    // Construct a faked response-object
    $response = new AuthenticationResponse();

    $response->type          = 'Joomla'; // ?
    $response->email         = $user->email;
    $response->fullname      = $user->name;
    $response->username      = $user->username;
    $response->password      = 'Not Actually Needed';
    $response->language      = $user->getParam('language'); // Not tested
    $response->status        = Authentication::STATUS_SUCCESS; // Woot Woot!
    $response->error_message = null; // to be sure

    // Needed so Cookies get set correctly by the user plugins
    PluginHelper::importPlugin('system');
    PluginHelper::importPlugin('user');

    $app->triggerEvent('onUserLogin', [
        (array) $response, [
            'action' => 'core.login.admin',

        ], ]);

    if ($_POST['htuser'] && $_POST['htpass']) {
        $auth = $_POST['htuser'] . ':' . $_POST['htpass'] . '@';
    } else {
        $auth = '';
    }

    $url = "//" . $auth . $_SERVER['HTTP_HOST'] . $subfolderIfAny . '/administrator/index.php?' . $dataObj->adminUrlAppend;

    $session->close();

    header("HTTP/1.1 303 See Other");
    header("Location: " . $url);
} catch (Exception $e) {
    echo $e->getMessage();
}
