<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\LanguageFactoryInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Session\Session;
use Joomla\CMS\User\UserFactoryInterface;
use Joomla\DI\Container;
use Joomla\Event\DispatcherInterface;
use Joomla\Session\SessionInterface;
use Psr\Log\LoggerInterface;

if (! defined('_JEXEC')) {
    define('_JEXEC', 1);
}
if (! defined('JPATH_PLATFORM')) {
    define('JPATH_PLATFORM', __DIR__ . '/../../../../libraries');
}
if (! defined('JOOMLA_MINIMUM_PHP')) {
    define('JOOMLA_MINIMUM_PHP', '7.2.5');
}
if (! defined('_BF_AUDIT')) {
    define('_BF_AUDIT', 1);
}

// Some old plugins need this
if (! defined('DS')) {
    define('DS', \DIRECTORY_SEPARATOR);
}

// find out where our Joomla Base paths are
define('JPATH_BASE', realpath(__DIR__ . '/../../../../'));

// Joomla requires this
require_once JPATH_BASE . DS . 'includes' . DS . 'defines.php';

require_once JPATH_BASE . DS . 'includes' . DS . 'framework.php';

if (! defined('JPATH_ADMINISTRATOR')) {
    define('JPATH_ADMINISTRATOR', realpath(__DIR__ . '/../../../../administrator/'));
}

// Fake a path -  Needed for pathetic extension update postFlights like JCH Optimise Plugin
if (! defined('JPATH_COMPONENT')) {
    define('JPATH_COMPONENT', realpath(__DIR__ . '/../../../../administrator/components/com_plugins'));
}

require 'bfApplicationMyjoomla.php';

// Boot the DI container
$container = Factory::getContainer();

$container->alias(JApplicationMyjoomla::class, 'JApplicationMyjoomla')
    ->share(
        'JApplicationMyjoomla',
        function (Container $container) {
            $app = new JApplicationMyjoomla(null, $container->get('config'), null, $container);

            // The session service provider needs Factory::$application, set it if still null
            if (null === Factory::$application) {
                Factory::$application = $app;
            }

            $app->setDispatcher($container->get(DispatcherInterface::class));
            $app->setLogger($container->get(LoggerInterface::class));
            $app->setSession($container->get(SessionInterface::class));
            $app->setUserFactory($container->get(UserFactoryInterface::class));

            return $app;
        },
        true
    );

/*
* Alias the session service keys to the web session service as that is the primary session backend for this application
*
* In addition to aliasing "common" service keys, we also create aliases for the PHP classes to ensure autowiring objects
* is supported.  This includes aliases for aliased class names, and the keys for alised class names should be considered
* deprecated to be removed when the class name alias is removed as well.
*/
$container->alias('session.web', 'session.web.administrator')
    ->alias('session', 'session.web.administrator')
    ->alias('JSession', 'session.web.administrator')
    ->alias(Session::class, 'session.web.administrator')
    ->alias(\Joomla\Session\Session::class, 'session.web.administrator')
    ->alias(SessionInterface::class, 'session.web.administrator');

// Instantiate the application.
$app = $container->get(JApplicationMyjoomla::class);

$lang = Factory::getContainer()
    ->get(LanguageFactoryInterface::class)
    ->createLanguage('en-GB', false);
$app->loadLanguage($lang);

// Set the application as global app
Factory::$application = $app;
Factory::$language    = $lang;

JLoader::register('JNamespacePsr4Map', JPATH_LIBRARIES . '/namespacemap.php');
$extensionPsr4Loader = new \JNamespacePsr4Map();
$extensionPsr4Loader->load();

// Don't trigger emails for Admin Login in Akeeba Admin Tools
// plugins/system/admintools/src/Utility/BlockedRequestHandler.php:286
// $app->getIdentity() is null issues
Factory::getApplication()->getSession()->set('plg_admintools.waf.loggedin', 1);

// Need to load the Joomla 5 Behaviour plugins in case the Backward Compatibility Plugin is needed
PluginHelper::importPlugin('behaviour', null, true, Factory::getApplication()->getDispatcher());

define('BF_JOOMLA_INIT_DONE', 1);
