<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Actionlogs\Administrator\Helper\ActionlogsHelper;

require 'bfEncrypt.php';
if (! defined('BF_JOOMLA_INIT_DONE')) {
    require_once 'bfInitJoomla.php';
}
require 'bfActivitylog.php';

/**
 * If we have got here then we have already passed through decrypting the encrypted header and so we are sure we are now
 * secure and no one else cannot run the code below.
 */
class bfReports
{
    private $db;

    /**
     * @param stdClass $_dataObj
     */
    public function __construct(
        private $_dataObj = null
    ) {
        $this->db = Factory::getContainer()->get('DatabaseDriver');
    }

    private function remotelog()
    {
        bfActivitylog::getInstance()->log(
            $this->_dataObj->who,
            $this->_dataObj->who_id,
            $this->_dataObj->what,
            $this->_dataObj->where,
            $this->_dataObj->where_id,
            $this->_dataObj->ip,
            $this->_dataObj->useragent,
            json_encode($this->_dataObj->meta, JSON_THROW_ON_ERROR),
            $this->_dataObj->action,
            $this->_dataObj->alertname,
            $this->_dataObj->constkey,
            $this->_dataObj->when
        );
        bfEncrypt::reply('success', $this->_dataObj);
    }

    /**
     * Retrieve Log Rows for reporting purposes.
     */
    private function getdata()
    {
        $fromDateTime = $this->_dataObj->f;
        $toDateTime   = $this->_dataObj->t;

        $sql = "select * from bf_activitylog WHERE
                `when` >= '%s'
                AND
                `when` <= '%s'
                AND 
                 `what` != 'Snapshot Taken' 
                AND 
                 `what` != 'Audit Started' 
                AND
                 `what` != 'mySites.guru connector'
                LIMIT 1000
                ";

        $this->db->setQuery(sprintf($sql, $fromDateTime, $toDateTime));

        $data = $this->db->loadObjectList();

        // Manipulate the base Uri in the Joomla Stack to provide compatibility with some 3pd extensions like ACL Manager!
        try {
            $uri = Uri::getInstance();

            $reflection   = new ReflectionClass($uri);
            $baseProperty = $reflection->getProperty('base');
            $baseProperty->setAccessible(true);
            $base           = $baseProperty->getValue();
            $base['prefix'] = $uri->toString(['scheme', 'host']);
            $base['path']   = '/';
            $baseProperty->setValue($base);
        } catch (ReflectionException) {
        }

        JLoader::register('ActionlogsHelper', JPATH_ADMINISTRATOR . '/components/com_actionlogs/helpers/actionlogs.php');

        $sql = "select * from #__action_logs WHERE
                 `log_date` >= '%s'
                AND
                 `log_date` <= '%s'
                AND 
                 `message_language_key` != '[mySites.guru] Snapshot Taken' 
                AND 
                 `message_language_key` != '[mySites.guru] Audit Started'  
                LIMIT 1000
                ";

        $this->db->setQuery(sprintf($sql, $fromDateTime, $toDateTime));
        $rows = $this->db->loadObjectList();

        // Load all language files needed
        ActionlogsHelper::loadActionLogPluginsLanguage();
        $lang = Factory::getApplication()->getLanguage();
        $lang->load('com_privacy', JPATH_ADMINISTRATOR, null, false, true);
        $lang->load('plg_system_actionlogs', JPATH_ADMINISTRATOR, null, false, true);
        $lang->load('plg_system_privacyconsent', JPATH_ADMINISTRATOR, null, false, true);

        // manipulate data to push to mysites.guru
        foreach ($rows as $row) {
            $row->what   = ActionlogsHelper::getHumanReadableLogMessage($row);
            $row->ip     = $row->ip_address;
            $row->when   = $row->log_date;
            $row->who_id = $row->user_id;
            $row->source = 'core_user_action_log';
        }

        $data = array_merge($data, $rows);

        bfEncrypt::reply('success', $data);
    }

    /**
     * I'm the controller - I run methods based on the requested action.
     */
    public function run()
    {
        $action = $this->_dataObj->remoteaction;

        return $this->$action();
    }
}

/** @var stdClass $dataObj The incoming decrypted request */
$preferences = new bfReports($dataObj);
$preferences->run();
